<?php

/***************************************************************************
 *              bot_install.php - [german - Deutsch] v1.0
 *                     --------------------
 *
 *
 *			begin		: Sunday, July, 10, 2005
 *			copyright	: (C) 2005 by "tomtom" for http://www.deutsche-phpbb-mods.de.vu/
 *			email		: thomas@muensterland.de
 *
 *
 *	        Translation based on: bot_install.php
 *
 *			begin		: Sunday, February 13, 2005
 *  		copyright	: (C) 2004 Adam Marcus
 *  		email		: adam_marcus@btinternet.com
 *
 *
 *
 ***************************************************************************/


/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

$version = "1.2.0";

// require includes
define('IN_PHPBB', 1);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'config.'.$phpEx);
include($phpbb_root_path . 'includes/constants.'.$phpEx);
include($phpbb_root_path . 'includes/db.'.$phpEx);

// get board config vars.
$sql = "SELECT * FROM " . $table_prefix . "config";
$result = $db->sql_query($sql);
while ( $row = $db->sql_fetchrow($result) )
{
	$board_config[$row['config_name']] = $row['config_value'];
}

$template_name = $board_config['default_style'];

//
// sql function: does the query and on error stores in an array
//
function _sql($sql, &$errored, &$error_ary)
{
	global $db;

	if( !($result = $db->sql_query($sql)) )
	{
		$errored = true;
		$error_ary['sql'][] = $sql;
		$error_ary['error_code'][] = $db->sql_error();
	}

	return $result;
}

//
// error function: standard error display
//
function page_error($error_title, $error)
{

?>
					<tr>
						<th colspan="2"><?php echo $error_title; ?></th>
					</tr>
					<tr>
						<td colspan="2" class="row1" align="center"><br /><span class="gen"><?php echo $error; ?></span><br /><br /></td>
					</tr>
<?php

}

//
// content function: finishes of the page
//
function page_footer()
{

?>
					<tr>
					  <td class="catBottom" align="center" colspan="2"><b><?php echo (( !MOD_INSTALLED )? "INSTALLATION FEHLGESCHLAGEND!" : "INSTALLATION VOLLSTNDIG! - LSCHE DIESE DATEI!") ?></b></td>
					</tr>
			</table>
		</table><br /></td>
	</tr>
</table>

<span="gen"><font size="1"> &copy; 2004 by Adam Marcus, translated 2005 by tomtom for http://www.deutsche-phpbb-mods.de.vu/ </font></span>

</center>

</body>

</html>

<?php

}

?>

<html>

<head>

<title> Bot Indexer MOD: Datenbank Updater (v<?php echo $version; ?>)</title>

<link rel="stylesheet" href="./templates/subSilver/subSilver.css" type="text/css">

<style type="text/css">
<!--

th		{ background-image: url('./templates/subSilver/images/cellpic3.gif') }
td.cat		{ background-image: url('./templates/subSilver/images/cellpic1.gif') }
td.rowpic	{ background-image: url('./templates/subSilver/images/cellpic2.jpg'); background-repeat: repeat-y }
td.catHead,td.catSides,td.catLeft,td.catRight,td.catBottom { background-image: url('./templates/subSilver/images/cellpic1.gif') }

/* Import the fancy styles for IE only (NS4.x doesn't use the @import function) */
@import url("./templates/subSilver/formIE.css");

//-->
</style>

</head>

<body bgcolor="#E5E5E5" text="#000000" link="#006699" vlink="#5584AA">

<center>

<table width="100%" border="0" cellspacing="0" cellpadding="10" align="center">

	<tr>
		<td class="bodyline" width="100%"><table width="100%" border="0" cellspacing="0" cellpadding="0">

			<tr>
				<td colspan="2"><table width="100%" border="0" cellspacing="0" cellpadding="0">

					<tr>
						<td><img src="./templates/subSilver/images/logo_phpBB.gif" border="0" alt="Forum Home" vspace="1" /></td>
						<td align="center" width="100%" valign="middle"><span class="maintitle">Bot Indexer MOD: Datenbank Updater (v<?php echo $version; ?>)</span></td>

					</tr>

				</table></td>

			</tr>

			<tr>
				<td><br /><br /></td>

			</tr>

			<tr>
				<td colspan="2"><table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
					<tr>
						<td><span style="line-height: 125%;" class="gen">Wilkommen zur Bot Indexer MOD Installation! Diese Datei ergnzt deine Datenbank um die Angaben, die fr die korrekte Arbeitsweise des MODs sorgen. Bislang wurde ausschliesslich die MySQL Seite des Installers getestet. Bitte sende mir im Falle von Fehlern oder Resultaten eine EMail: <a href='mailto:adam_marcus@btinternet.com'>adam_marcus@btinternet.com</a>.</span><br /><br /></td>
					</tr>
				</table></td>
			</tr>

			<tr><td colspan="2"><center><table width="90%" cellpadding="2" cellspacing="1" border="0" class="forumline">

			<tr>
				<th colspan="2">Basic-Informationen</th>
			</tr>


			<tr>
					<td class="row1" align="right" width="30%"><span class="gen">Datenbank Typ:</span></td>
					<td class="row2"><input type="text" value="<?php echo ((!defined('SQL_LAYER')) ? "No database found!" : SQL_LAYER); ?>" readonly></td>
			</tr>

			<tr>
					<td class="row1" align="right" width="30%"><span class="gen">Mod Version:</span></td>
					<td class="row2"><input type="text" value="<?php echo $version; ?>" readonly></td>
			</tr>

<?php

// clear error arrays
$error_ary = array();
$errored = false;

// check to see if table exisits? if it does do update!
$sql = "SELECT * FROM " . $table_prefix . "bots";
_sql($sql, $errored, $error_ary);

if ($errored)
{

// clear error arrays
$error_ary = array();
$errored = false;

// mmmmm create the tables!
switch ( SQL_LAYER )
{

	case 'mysql':
	case 'mysql4':
		$sql = "CREATE TABLE " . $table_prefix  . "bots (
  			   bot_id tinyint(3) unsigned NOT NULL auto_increment,
  			   bot_name varchar(255) DEFAULT '' NOT NULL,
  			   bot_agent text  DEFAULT '' NOT NULL,
  			   last_visit varchar(255) DEFAULT '' NOT NULL,
  			   bot_visits varchar(255) DEFAULT '0' NOT NULL,
  			   bot_pages varchar(255) DEFAULT '0' NOT NULL,
  			   pending_agent text DEFAULT '' NOT NULL,
  			   pending_ip text DEFAULT '' NOT NULL,
  			   bot_ip text DEFAULT '' NOT NULL,
			   bot_style varchar(255) DEFAULT '" . $template_name . "' NOT NULL,
  			   PRIMARY KEY  (bot_id)
			 );";
		_sql($sql, $errored, $error_ary);
		$sql = "ALTER TABLE " . $table_prefix . "sessions ADD is_robot VARCHAR(255) DEFAULT '0' NOT NULL";
		break;
	case 'postgresql':
		$sql = "CREATE SEQUENCE " . $table_prefix . "bots_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
			CREATE TABLE " . $table_prefix  . "bots (
  			   bot_id int2 DEFAULT nextval('" . $table_prefix . "bots_id_seq'::text) NOT NULL,
  			   bot_name varchar(255) DEFAULT '' NOT NULL,
  			   bot_agent text  DEFAULT '' NOT NULL,
  			   last_visit varchar(255) DEFAULT '' NOT NULL,
  			   bot_visits varchar(255) DEFAULT '0' NOT NULL,
  			   bot_pages varchar(255) DEFAULT '0' NOT NULL,
  			   pending_ip text DEFAULT '' NOT NULL,
  			   pending_agent text DEFAULT '' NOT NULL,
  			   bot_ip text DEFAULT '' NOT NULL,
			   bot_style varchar(255) DEFAULT '" . $template_name . "' NOT NULL,
  			   CONSTRAINT " . $table_prefix . "bots_pkey PRIMARY KEY (bot_id)
			);ALTER TABLE " . $table_prefix . "sessions ADD is_robot varchar(255) NOT NULL;
			ALTER TABLE " . $table_prefix . "sessions ALTER COLUMN is_robot SET DEFAULT '0';";
		break;
	case 'mssql-odbc':
	case 'mssql':
		$sql = "BEGIN TRANSACTION
			GO
			CREATE TABLE [" . $table_prefix  . "bots] (
  			   [bot_id] [smallint] IDENTITY (1, 1) NOT NULL,
  			   [bot_name] [varchar] (255) NOT NULL,
  			   [bot_agent] [text] NOT NULL,
  			   [last_visit] [varchar] (255) NOT NULL,
			   [bot_style] [varchar] (255) NOT NULL,
			   [bot_visits] [varchar] (255) NOT NULL,
			   [bot_pages] [varchar] (255) NOT NULL,
  			   [pending_agent] [text] NOT NULL,
  			   [pending_ip] [text] NOT NULL,
  			   [bot_ip] [text] NOT NULL
			) ON [PRIMARY]
		     	GO
			ALTER TABLE [" . $table_prefix . "bots] WITH NOCHECK ADD
		           CONSTRAINT [PK_" . $table_prefix . "bots] PRIMARY KEY  CLUSTERED
			   (
			      [bot_id]
			   )  ON [PRIMARY]
			GO
			ALTER TABLE [" . $table_prefix . "bots] WITH NOCHECK ADD
			  CONSTRAINT [DF_" . $table_prefix . "bots_bot_visits] DEFAULT (0) FOR [bot_visits],
			  CONSTRAINT [DF_" . $table_prefix . "bots_bot_style] DEFAULT (" . $template_name . "FOR [bot_style],

 			  CONSTRAINT [DF_" . $table_prefix . "bots_bot_pages] DEFAULT (0) FOR [bot_pages]
			GO
			ALTER TABLE [" . $table_prefix . "sessions] WITH NOCHECK ADD
			  [is_robot] [varchar] (255) NOT NULL,
			  CONSTRAINT [DF_" . $table_prefix . "sessions_is_robot] DEFAULT (0) FOR [is_robot],
			GO
			COMMIT
			GO";
		break;
	default:
		page_error("Kann die Datenbank nicht updaten!", "Sorry, entweder wurden die ntigen Daten nicht in deiner Datenbank gefunden, oder deine Datenbank wird vom Installer nicht untersttzt.");
		page_footer();
		die();
		break;

}


// do the query
_sql($sql, $errored, $error_ary);

// on error display it
if ( $errored )
{
	// the mod  install hasn't been successful
	define('MOD_INSTALLED', false);

	$errors = "Eine Abfragen schlugen fehl, die Statements und Fehler sind unten aufgefhrt:\n<ul>";

		for($i = 0; $i < count($error_ary['sql']); $i++)
		{

			$errors .= "<li><b>Error</b>:  " . $error_ary['error_code'][$i]['message'] . " <br />";
			$errors .= "<b>SQL</b>:  " . $error_ary['sql'][$i] . " <br /><br /></li>";

		}

	$errors .= "</ul>";

	$result = "<font color='red'><b>Installation der Datenbanknderungen fehlgeschlagen!</b></font>\n";

} else {

	$errors = "Keine Fehler.";

	$result = "<font color='green'><b>Installation der Datenbanknderungen erfolgreich!</b></font>";

}

?>
			<tr>
				<th colspan="2">Datenbank Installationsergebnisse</th>
			</tr>

			<tr>
					<td class="row1" align="right" width="30%"><span class="gen">Ergebnis:</span></td>
					<td class="row2"><font size="1"><?php echo $result; ?></font></td>
			</tr>

			<tr>
					<td class="row1" align="right" width="30%"><span class="gen">Fehler:</span></td>
					<td class="row2"><font size="1"><?php echo $errors; ?></font></td>
			</tr>

<?php


// clear error arrays
$error_ary = array();
$errored = false;


// input the data
$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Googlebot', 'Google', '216.239.46.|64.68.8|64.68.9|164.71.1.|192.51.44.|66.249.71.|66.249.66.|66.249.65.|66.249.64.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Alexa', 'ia_archiver', '66.28.250.|209.237.238.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Inktomi', 'Slurp/', '216.35.116.|66.196.|66.94.230.|202.212.5.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Infoseek', 'Infoseek', '204.162.9|205.226.203|206.3.30.|210.236.233.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Alta Vista', 'Scooter', '194.221.84.|204.123.28.|208.221.35|212.187.226.|66.17.148.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Lycos', 'Lycos', '208.146.27.|209.202.19|209.67.22|202.232.118.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('FAST', 'alltheweb', '146.101.142.2|216.35.112.|64.41.254.2|213.188.8.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('WiseNut', 'WISEnut', '64.241.243.|209.249.67.1|216.34.42.|66.35.208.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('MSN', 'msnbot/', '131.107.3.|204.95.98.|131.107.1|65.54.164.95|207.46.98.')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Looksmart', 'MARTINI', '64.241.242.|207.138.42.212')";
_sql($sql, $errored, $error_ary);

$sql = "INSERT INTO " . $table_prefix . "bots (bot_name, bot_agent, bot_ip)
	VALUES ('Ask Jeeves', 'teoma', '216.200.130.|216.34.121.|63.236.92.1|64.55.148.|65.192.195.|65.214.36.')";
_sql($sql, $errored, $error_ary);


} else {

switch ( SQL_LAYER )
{

	case 'mysql':
	case 'mysql4':
		$sql = "ALTER TABLE " . $table_prefix . "sessions ADD is_robot VARCHAR(255) DEFAULT '0' NOT NULL;";
		_sql($sql, $errored, $error_ary);
		$sql = "ALTER TABLE " . $table_prefix . "bots ADD bot_style VARCHAR(255) DEFAULT '" . $template_name . "' NOT NULL;";
		_sql($sql, $errored, $error_ary);
		$sql = 	"UPDATE " . $table_prefix . "bots SET bot_ip='216.239.46.|64.68.8|64.68.9|164.71.1.|192.51.44.|66.249.71.|66.249.66.|66.249.65.|66.249.64.' WHERE bot_id='1'";
		_sql($sql, $errored, $error_ary);
		$sql = 	"UPDATE " . $table_prefix . "bots SET bot_agent='Google' WHERE bot_id='1'";
		_sql($sql, $errored, $error_ary);

		for ($cycle_bots = 1; $cycle_bots <= 11; $cycle_bots++)
		{
			$sql = 	"UPDATE " . $table_prefix . "bots SET pending_agent='' WHERE bot_id='$cycle_bots'";
			_sql($sql, $errored, $error_ary);
			$sql = 	"UPDATE " . $table_prefix . "bots SET pending_ip='' WHERE bot_id='$cycle_bots'";
			_sql($sql, $errored, $error_ary);
		}

		$sql = 	"UPDATE " . $table_prefix . "bots SET bot_ip='131.107.3.|204.95.98.|131.107.1|65.54.164.95|207.46.98.' WHERE bot_id='9'";
		_sql($sql, $errored, $error_ary);
		break;
	case 'postgresql':
		$sql = "ALTER TABLE " . $table_prefix . "sessions ADD is_robot varchar(255) NOT NULL";
		_sql($sql, $errored, $error_ary);
		$sql = "ALTER TABLE " . $table_prefix . "sessions ALTER COLUMN is_robot SET DEFAULT '0'";
		_sql($sql, $errored, $error_ary);
		$sql = "ALTER TABLE " . $table_prefix . "bots ADD bot_style varchar(255) NOT NULL";
		_sql($sql, $errored, $error_ary);
		$sql = "ALTER TABLE " . $table_prefix . "bots ALTER COLUMN bot_style SET DEFAULT '" . $template_name . "'";
		_sql($sql, $errored, $error_ary);
		break;
	case 'mssql-odbc':
	case 'mssql':
		$sql = "BEGIN TRANSACTION
			GO
			ALTER TABLE [" . $table_prefix . "sessions] WITH NOCHECK ADD
			  [is_robot] [varchar] (255) NOT NULL,
			  CONSTRAINT [DF_" . $table_prefix . "sessions_is_robot] DEFAULT (0) FOR [is_robot],
			GO
			ALTER TABLE [" . $table_prefix . "bots] WITH NOCHECK ADD
			  [bot_style] [varchar] (255) NOT NULL,
			  CONSTRAINT [DF_" . $table_prefix . "bots_bot_style] DEFAULT (" .  $template_name . ") FOR [bot_style],
			GO
			COMMIT
			GO";
		_sql($sql, $errored, $error_ary);
		break;
	default:
		page_error("Kann die Datenbank nicht updaten!", "Sorry, entweder wurden die ntigen Daten nicht in deiner Datenbank gefunden, oder deine Datenbank wird vom Installer nicht untersttzt.");
		page_footer();
		die();
		break;

}

}


// on error display it
if ( $errored )
{

	// the mod  install hasn't been successful
	define('MOD_INSTALLED', false);

	$errors = "Eine Abfragen schlugen fehl, die Statements und Fehler sind unten aufgefhrt:\n<ul>";

		for($i = 0; $i < count($error_ary['sql']); $i++)
		{

			$errors .= "<li><b>Error</b>:  " . $error_ary['error_code'][$i]['message'] . " <br />";
			$errors .= "<b>SQL</b>:  " . $error_ary['sql'][$i] . " <br /><br /></li>";

		}

	$errors .= "</ul>";

	$result = "<font color='red'><bInstallation der Datenbanknderungen fehlgeschlagen!</b></font>\n";

} else {

	$errors = "Keine Fehler.";

	$result = "<font color='green'><b>Installation der Datenbanknderungen erfolgreich!</b></font>";

}

?>
			<tr>
				<th colspan="2">Datenbank Update-Ergebnisse</th>
			</tr>

			<tr>
					<td class="row1" align="right" width="30%"><span class="gen">Ergebnis:</span></td>
					<td class="row2"><font size="1"><?php echo $result; ?></font></td>
			</tr>

			<tr>
					<td class="row1" align="right" width="30%"><span class="gen">Fehler:</span></td>
					<td class="row2"><font size="1"><?php echo $errors; ?></font></td>
			</tr>

<?php


// has the mod been successful?
if ( !defined('MOD_INSTALLED') ) define('MOD_INSTALLED', true);

page_footer();

?>